﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

using System.Runtime.InteropServices;

using AMESDK.NET;

[StructLayout(LayoutKind.Sequential)]
public struct SYSTEMTIME
{
    public ushort wYear;
    public ushort wMonth;
    public ushort wDayOfWeek;
    public ushort wDay;
    public ushort wHour;
    public ushort wMinute;
    public ushort wSecond;
    public ushort wMilliseconds;
}

namespace SC2A0
{
    public partial class Form1 : Form
    {
        [DllImport("user32.dll")]
        public static extern uint FindWindow(string classname, string windowname);

        [DllImport("user32.dll")]
        public static extern uint SendMessage(uint hWnd, uint wMsg, uint wParam, uint lParam);

        [DllImport("user32.dll")]
        public static extern uint PostMessage(uint hWnd, uint wMsg, uint wParam, uint lParam);

        [DllImport("kernel32.dll", EntryPoint = "SystemTimeToFileTime")]
       public static extern int SystemTimeToFileTime(ref SYSTEMTIME lpSystemTime, ref FILETIME lpFileTime);

        [DllImport("Kernel32.dll ")]
        public static extern void GetLocalTime(ref SYSTEMTIME sysTime);

        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        public static string ByteArrayToString(byte[] array)
        {
            if (array == null)
            {
                throw new ArgumentNullException("array");
            }
            return Encoding.ASCII.GetString(array);
        }

        public uint m_nDisplayTabNumber = 0;  // 0 = LIVE / 1 = RECORD PLAYBACK / 2 = MAIN REALTIME PLAYBACK / 3 = SUB REALTIME PLAYBACK

        public uint m_nDeviceSerialNumber = 0; // DEVICE SERIAL NUMBER

        public uint[] m_hVideoDev = new uint[4]; // VIDEO STREAM CAPTURE DEVICE

        public uint[] m_hVideoMainEncoderDev = new uint[4]; // H.264 MAIN.STREAM CAPTURE DEVICE

        public uint[] m_hVideoSubEncoderDev = new uint[4]; // H.264 SUB.STREAM CAPTURE DEVICE

        uint[] m_hAudioDev = new uint[4]; // AUDIO STREAM CAPTURE DEVICE

        uint[] m_hAudioAACEncoderDev = new uint[4]; // AUDIO AAC SOFTWARE ENCODER DEVICE         

        uint[] m_hFileRendererDev = new uint[4]; // FILE RENDERER DEVICE

        uint[] m_nFileRendererRecordState = new uint[4]; // 0 = STOP / 1 = ACQUIRE / 2 = START

        public volatile bool[] m_bFileRendererChangeNotify = new bool[4]; // FILE.CHANGING.EVENT NOTIFY (0 = NONE / 1 = CHANGE)        

        public DateTime[] m_sFileRendererChangeSystemTime = new DateTime[4]; // FILE.CHANGING.EVENT SYSTEM TIME

        public string[] m_pFileRendererChangeDevName = new string[4]; // FILE.CHANGING.EVENT DEVICE NAME        

        private Object thisLock = new Object();

        public uint[] m_hFileSourceDev = new uint[4]; // FILE SOURCE DEVICE

        uint m_hNetworkRendererDev; // FNETWORK RENDERER DEVICE

        uint[] m_nNetworkRendererStreamingState = new uint[4]; // 0 = STOP / 1 = ACQUIRE / 2 = START

        uint[]  g_n_video_frame_number= new uint[4];

        uint[] g_n_video_main_encoder_frame_number = new uint[4];

        uint[] g_n_video_sub_encoder_frame_number = new uint[4];

        double[] g_d_video_start_sample_time = new double[4];

        double[] g_d_video_main_encoder_start_sample_time = new double[4];

        double[] g_d_video_sub_encoder_start_sample_time = new double[4];

        double[] g_d_video_stop_sample_time = new double[4];

        double[] g_d_video_main_encoder_stop_sample_time = new double[4];

        double[] g_d_video_sub_encoder_stop_sample_time = new double[4];

        ulong[] g_n_video_main_encoder_stream_size = new ulong[4];

        ulong[] g_n_video_sub_encoder_stream_size = new ulong[4];

        bool  g_b_is_start_statistics = false;

        uint[] g_n_video_streaming_frame_number = new uint[4];

        uint[] g_n_audio_streaming_frame_number = new uint[4];

        ulong[] g_n_video_streaming_start_sample_time = new ulong[4];

        ulong[] g_n_audio_streaming_start_sample_time = new ulong[4];

        IntPtr[][] p_queue_stream_buffer = new IntPtr[4][]; // SYNC VIDEO & AUDIO

        ulong[][] n_queue_stream_buffer_size = new ulong[4][];

        ulong[] n_queue_stream_buffer_index = new ulong[4];

        FILETIME m_n_file_time;

        // DATA STRUCTURE
        //
        EXPORTS.AMESDK_SECTION_INFO[] m_pSectionData = new EXPORTS.AMESDK_SECTION_INFO[4];

        EXPORTS.AMESDK_MOTION_INFO[] m_pMotionData = new EXPORTS.AMESDK_MOTION_INFO[4];

        EXPORTS.AMESDK_GPS_INFO[] m_pGpsData = new EXPORTS.AMESDK_GPS_INFO[4];

        EXPORTS.AMESDK_POS_INFO[] m_pPosData = new EXPORTS.AMESDK_POS_INFO[4];

        EXPORTS.AMESDK_FILE_INFO[] m_pFileInfo = new EXPORTS.AMESDK_FILE_INFO[4];

        // CALLBACK FUNCTION
        //
        EXPORTS.PF_BUFFER_CALLBACK m_pVideoBufferCB;

        EXPORTS.PF_BUFFER_CALLBACK m_pAudioBufferCB;

        EXPORTS.PF_BUFFER_CALLBACK m_pVideoMainEncoderBufferCB;

        EXPORTS.PF_BUFFER_CALLBACK m_pVideoSubEncoderBufferCB;

        MyChannelControl[] m_cChannelControl_LIVE = new MyChannelControl[4]; // LIVE STREAM DISPLAY WINDOW

        MyChannelControl[] m_cChannelControl_FILE = new MyChannelControl[4]; // FILE STREAM DISPLAY WINDOW (RECORD PLAYBACK)

        MyChannelControl[] m_cChannelControl_H264_MAIN = new MyChannelControl[4]; // H.264 MAIN.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

        MyChannelControl[] m_cChannelControl_H264_SUB = new MyChannelControl[4]; // H.264 SUB.STREAM DISPLAY WINDOW (REALTIME PLAYBACK) 

        MySetupControl m_cSetupControl = new MySetupControl();

        public MyPeopertyDlg m_cPropertyDlg = new MyPeopertyDlg();

        uint on_process_video_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;

            uint hVideoDev = m_hVideoDev[i];

            uint bIsVisible = 0;

            if (g_b_is_start_statistics)
            {
                SYSTEMTIME s_system_times = new SYSTEMTIME(); GetLocalTime(ref s_system_times);                

                SystemTimeToFileTime(ref s_system_times, ref m_n_file_time);

                ulong n_system_time = (ulong)((((m_n_file_time.dwHighDateTime) << 32) | m_n_file_time.dwLowDateTime));

                dSampleTime = (uint)(n_system_time / 10000) / 1000.0;

                if (g_n_video_frame_number[i]++ == 0) { g_d_video_start_sample_time[i] = dSampleTime; }

                g_d_video_stop_sample_time[i] = dSampleTime;
            }            

            if (m_nDisplayTabNumber == 0) { bIsVisible = 1; }

            return bIsVisible; // DISPLAY ON WINDOW
        }

        // MAIN VIDEO ENCODER CALLBACK FUNCTION
        //
        uint on_process_video_main_encoder_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;            

            uint i = nChannelNumber;

            bool bKeyFrame = (bIsKeyFrame == 1) ? true : false;

            bool bIsStreaming = (m_nNetworkRendererStreamingState[i] == 0x00000002) ? true : false;

            uint bIsVisible = 0;

            if (bKeyFrame) // WAITING KEY FRAME
            {
                if (m_nNetworkRendererStreamingState[i] == 0x00000001)
                {
                    m_nNetworkRendererStreamingState[i] = 0x00000002; // TO GOTO START STATE

                    bIsStreaming = true;
                }
            }

            if (bIsStreaming)
            {
                ulong n_sample_time = (ulong)(dSampleTime * 10000000);

                if (g_n_video_streaming_frame_number[i]++ == 0)
                {
                    SYSTEMTIME s_system_times = new SYSTEMTIME(); GetLocalTime(ref s_system_times);

                    SystemTimeToFileTime(ref s_system_times, ref m_n_file_time);

                    ulong n_system_time = (ulong)((((m_n_file_time.dwHighDateTime) << 32) | m_n_file_time.dwLowDateTime));

                    g_n_video_streaming_start_sample_time[i] = n_system_time;
                }

                uint n_buffer_queue_size = 0;

                uint n_frame_queue_size = 0;

                uint n_clients = 0;

                EXPORTS.AMESDK_NETWORK_GET_VIDEO_STREAM_STATISTICS(m_hNetworkRendererDev, i, ref n_buffer_queue_size, ref n_frame_queue_size, ref n_clients);
                
                ulong j = n_queue_stream_buffer_index[i];

                if (n_queue_stream_buffer_size[i][j] != 0)
                {
                    EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER(m_hNetworkRendererDev, i,  (uint)p_queue_stream_buffer[i][j].ToInt32(), (uint)n_queue_stream_buffer_size[i][j], 0, 0, 0);
                }

                // COPY VIDEO STREAM TO QUEUE BUFFER
                //
                EXPORTS.HELPER_MEMCPY((uint)p_queue_stream_buffer[i][j].ToInt32(), pBuffer, nBufferLen);                                

                n_queue_stream_buffer_size[i][j] = nBufferLen;

                n_queue_stream_buffer_index[i]++;

                n_queue_stream_buffer_index[i] %= 24;

                // PUSH ONE VIDEO STREAM BUFFER INTO NETWORK
                //
                //EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER(m_hNetworkRendererDev, i, pBuffer, nBufferLen, bIsKeyFrame, 0, 0); 
            }

            if (g_b_is_start_statistics)
            {
                SYSTEMTIME s_system_times = new SYSTEMTIME(); GetLocalTime(ref s_system_times);

                SystemTimeToFileTime(ref s_system_times, ref m_n_file_time);

                ulong n_system_time = (ulong)((((m_n_file_time.dwHighDateTime) << 32) | m_n_file_time.dwLowDateTime));

                dSampleTime = (uint)(n_system_time / 10000) / 1000.0;

                if (g_n_video_sub_encoder_frame_number[i]++ == 0) { g_d_video_sub_encoder_start_sample_time[i] = dSampleTime; }

                g_d_video_sub_encoder_stop_sample_time[i] = dSampleTime;

                g_n_video_sub_encoder_stream_size[i] += nBufferLen;
            }

            if (m_nDisplayTabNumber == 2) { bIsVisible = 1; }

            return bIsVisible; // DISPLAY ON WINDOW
        }

        // SUB VIDEO ENCODER CALLBACK FUNCTION
        //
        uint on_process_video_sub_encoder_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;            

            bool bKeyFrame = (bIsKeyFrame == 1) ? true : false;                        

            uint bIsVisible = 0;
        
            if (m_nDisplayTabNumber == 3) { bIsVisible = 1; }            

            return bIsVisible; // DISPLAY ON WINDOW
        }

        // AUDIO CALLBACK FUNCTION
        //
        uint on_process_audio_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;            

            bool bIsStreaming = (m_nNetworkRendererStreamingState[i] == 0x00000002) ? true : false;

            uint bIsMute = 0;

            if (bIsStreaming)
            {
                ulong n_src_sample_time = (ulong)(dSampleTime * 10000000);

                ulong n_dst_sample_time = 0;

                uint pStreamBuffer = 0, nStreamBufferSize = 0;

                EXPORTS.AMESDK_CODEC_ENCODE(m_hAudioAACEncoderDev[i], pBuffer, nBufferLen, ref pStreamBuffer, ref nStreamBufferSize, n_src_sample_time, ref n_dst_sample_time);

                if (g_n_audio_streaming_frame_number[i]++ == 0)
                {
                    SYSTEMTIME s_system_times = new SYSTEMTIME(); GetLocalTime(ref s_system_times);

                    SystemTimeToFileTime(ref s_system_times, ref m_n_file_time);

                    ulong n_system_time = (ulong)((((m_n_file_time.dwHighDateTime) << 32) | m_n_file_time.dwLowDateTime));

                    g_n_audio_streaming_start_sample_time[i] = n_system_time;
                }                

                //long delay = (long)(g_n_video_streaming_start_sample_time[i] - g_n_audio_streaming_start_sample_time[i]) * 10;
                
                //EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER(m_hNetworkRendererDev, i, pStreamBuffer, nStreamBufferSize, delay - 1000000);

                if (nStreamBufferSize > 0)
                {
                    EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER(m_hNetworkRendererDev, i, pStreamBuffer, nStreamBufferSize, 0);
                }
            }

            if (m_nDisplayTabNumber == 0) { bIsMute = 1; }

            if (m_nDisplayTabNumber == 2) { bIsMute = 1; }

            return bIsMute;
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            uint i = 0, j = 0;
            
            for (i = 0; i < n_queue_stream_buffer_size.Length; i++) 
            {
                n_queue_stream_buffer_size[i] = new ulong[30]; 
            }

            for (i = 0; i < p_queue_stream_buffer.Length; i++)
            {
                p_queue_stream_buffer[i] = new IntPtr[30];
            }

            // ALLOCATE STREAMING BUFFER MEMORY
            //
            for (i = 0; i < 4; i++)
            {
                for (j = 0; j < 30; j++)
                {
                    p_queue_stream_buffer[i][j] = Marshal.AllocHGlobal(608256); // 704x576x1.5

                    n_queue_stream_buffer_size[i][j] = 0;

                    n_queue_stream_buffer_index[i] = 0;
                }
            }
           

            // USER INTERFACE PROGRAMMING (MAIN FORM)
            //
            System.Drawing.Size BorderSize = this.Size - this.ClientSize;

            this.Width = BorderSize.Width + 704;

            this.Height = BorderSize.Width + 480;

            for (i = 0; i < 4; i++)
            {
                m_cChannelControl_LIVE[i] = new MyChannelControl();

                m_cChannelControl_FILE[i] = new MyChannelControl();

                m_cChannelControl_H264_MAIN[i] = new MyChannelControl();

                m_cChannelControl_H264_SUB[i] = new MyChannelControl();

                m_cChannelControl_LIVE[i].Parent = this;

                m_cChannelControl_FILE[i].Parent = this;

                m_cChannelControl_H264_MAIN[i].Parent = this;

                m_cChannelControl_H264_SUB[i].Parent = this;

                if (i == 0)
                {
                    m_cChannelControl_LIVE[i].Left = 0;
                    m_cChannelControl_FILE[i].Left = 0;
                    m_cChannelControl_H264_MAIN[i].Left = 0;
                    m_cChannelControl_H264_SUB[i].Left = 0;
                }

                if (i == 1)
                {
                    m_cChannelControl_LIVE[i].Left = 352;
                    m_cChannelControl_FILE[i].Left = 352;
                    m_cChannelControl_H264_MAIN[i].Left = 352;
                    m_cChannelControl_H264_SUB[i].Left = 352;
                }

                if (i == 2)
                {
                    m_cChannelControl_LIVE[i].Left = 0;
                    m_cChannelControl_FILE[i].Left = 0;
                    m_cChannelControl_H264_MAIN[i].Left = 0;
                    m_cChannelControl_H264_SUB[i].Left = 0;
                }

                if (i == 3)
                {
                    m_cChannelControl_LIVE[i].Left = 352;
                    m_cChannelControl_FILE[i].Left = 352;
                    m_cChannelControl_H264_MAIN[i].Left = 352;
                    m_cChannelControl_H264_SUB[i].Left = 352;
                }

                if (i == 0)
                {
                    m_cChannelControl_LIVE[i].Top = 0;
                    m_cChannelControl_FILE[i].Top = 0;
                    m_cChannelControl_H264_MAIN[i].Top = 0;
                    m_cChannelControl_H264_SUB[i].Top = 0;
                }

                if (i == 1)
                {
                    m_cChannelControl_LIVE[i].Top = 0;
                    m_cChannelControl_FILE[i].Top = 0;
                    m_cChannelControl_H264_MAIN[i].Top = 0;
                    m_cChannelControl_H264_SUB[i].Top = 0;
                }

                if (i == 2)
                {
                    m_cChannelControl_LIVE[i].Top = 240;
                    m_cChannelControl_FILE[i].Top = 240;
                    m_cChannelControl_H264_MAIN[i].Top = 240;
                    m_cChannelControl_H264_SUB[i].Top = 240;
                }

                if (i == 3)
                {
                    m_cChannelControl_LIVE[i].Top = 240;
                    m_cChannelControl_FILE[i].Top = 240;
                    m_cChannelControl_H264_MAIN[i].Top = 240;
                    m_cChannelControl_H264_SUB[i].Top = 240;
                }

                m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(352, 240);
                m_cChannelControl_FILE[i].Size = new System.Drawing.Size(352, 240);
                m_cChannelControl_H264_MAIN[i].Size = new System.Drawing.Size(352, 240);
                m_cChannelControl_H264_SUB[i].Size = new System.Drawing.Size(352, 240);

                m_cChannelControl_LIVE[i].Visible = true;
                m_cChannelControl_FILE[i].Visible = false;
                m_cChannelControl_H264_MAIN[i].Visible = false;
                m_cChannelControl_H264_SUB[i].Visible = false;

                m_cChannelControl_LIVE[i].m_nChannelNumber = i + 0x1000000;
                m_cChannelControl_FILE[i].m_nChannelNumber = i + 0x2000000;
                m_cChannelControl_H264_MAIN[i].m_nChannelNumber = i + 0x4000000;
                m_cChannelControl_H264_SUB[i].m_nChannelNumber = i + 0x8000000;
            }

            for (i = 0; i < 4; i++)
            {
                m_hVideoDev[i] = 0xFFFFFFFF;

                m_hVideoMainEncoderDev[i] = 0xFFFFFFFF;

                m_hVideoSubEncoderDev[i] = 0xFFFFFFFF;

                m_hAudioDev[i] = 0xFFFFFFFF;

                m_hAudioAACEncoderDev[i] = 0xFFFFFFFF;

                m_hFileRendererDev[i] = 0xFFFFFFFF;

                m_nFileRendererRecordState[i] = 0;

                m_sFileRendererChangeSystemTime[i] = DateTime.Now;

                m_pFileRendererChangeDevName[i] = "";

                m_hFileSourceDev[i] = 0xFFFFFFFF;

                m_hNetworkRendererDev = 0xFFFFFFFF;

                m_nNetworkRendererStreamingState[i] = 0;
            }

            // CREATE CALLBACK FUNCTION
            // 
            m_pVideoBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_video_buffer);

            m_pAudioBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_audio_buffer);

            m_pVideoMainEncoderBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_video_main_encoder_buffer);

            m_pVideoSubEncoderBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_video_sub_encoder_buffer);
            //

            m_nDisplayTabNumber = 0;

            // USER INTERFACE PROGRAMMING (SETUP CONTROL)
            //
            m_cSetupControl = new MySetupControl();            

            m_cSetupControl.m_pMainForm = this;

            m_cSetupControl.m_cFileManagerControl.m_pMainForm = this;

            BorderSize = m_cSetupControl.Size - m_cSetupControl.ClientSize;

            this.Top = this.Top - 75;

            m_cSetupControl.Top = this.Bottom + 5;

            m_cSetupControl.Left = this.Left - ((1248 - 704 - BorderSize.Width) / 2);

            m_cSetupControl.Width = 0;

            m_cSetupControl.Height = 0;

            m_cSetupControl.Visible = false;

            m_cSetupControl.Show();

            m_cSetupControl.Visible = false;

            HwInitialize();

            m_cSetupControl.Width = BorderSize.Width + 1248;

            m_cSetupControl.Height = BorderSize.Height + 25 * 12;

            m_cSetupControl.Visible = true; 
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            HwUninitialize();

            m_cSetupControl.Close();

            uint i = 0, j = 0;
            
            for (i = 0; i < 4; i++ )
            {
                for (j = 0; j < 30; j++ )
                {
                    Marshal.FreeHGlobal(p_queue_stream_buffer[i][j]);

                    n_queue_stream_buffer_size[i][j] = 0;

                    n_queue_stream_buffer_index[i] = 0;
                }
            }
        }

        public bool HwInitialize()
        {
            // GET DEVICE PARAMETERS FROM SETUP DIALOG
            //
            int std = 0;

            int[] cx = new int[8];

            int[] cy = new int[8];

            double[] fps = new double[8];

            int[] deinterlace = new int[8];

            int[] rcmode = new int[8];

            int[] bitrate = new int[8];

            int[] quality = new int[8];

            int[] gop = new int[8];

            int[] qpstep = new int[8];

            int[] peakbitrate = new int[8];

            int[] troughquality = new int[8];

            int i = 0;

            m_cSetupControl.GetStandardParameter(ref std);

            m_cSetupControl.GetResolutionParameter(ref cx, ref cy);

            m_cSetupControl.GetFrameRateParameter(ref fps);

            m_cSetupControl.GetDeinterlaceParameter(ref deinterlace);

            m_cSetupControl.GetRecordModeParameter(ref rcmode);

            m_cSetupControl.GetBitRateParameter(ref bitrate);

            m_cSetupControl.GetQualityParameter(ref quality);

            m_cSetupControl.GetGOPParameter(ref gop);

            m_cSetupControl.GetQPStepParameter(ref qpstep);

            m_cSetupControl.GetPeakBitRateParameter(ref peakbitrate);

            m_cSetupControl.GetTroughQualityParameter(ref troughquality);

            // INITIALIZE NETWORK RENDERERS (RTSP)
            //
            m_hNetworkRendererDev = 0xFFFFFFFF;

            string strNetworkRendererName = "Common Analog Network Renderer streams=4";

            m_hNetworkRendererDev = EXPORTS.AMESDK_CREATE(ref strNetworkRendererName, 0, 5, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

            if ((m_hNetworkRendererDev & 0x80000000) == 0x80000000) { m_hNetworkRendererDev = 0xFFFFFFFF; }

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 0x34363248, (uint)cx[0], (uint)cy[0], 24, fps[0], (uint)(bitrate[0] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 0x34363248, (uint)cx[1], (uint)cy[1], 24, fps[1], (uint)(bitrate[1] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 0x34363248, (uint)cx[2], (uint)cy[2], 24, fps[2], (uint)(bitrate[2] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 0x34363248, (uint)cx[3], (uint)cy[3], 24, fps[3], (uint)(bitrate[3] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 0x00000001, 1, 16, 8000, 1 * 16 * 8000 * 4); 

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 0x00000001, 1, 16, 8000, 1 * 16 * 8000 * 4);

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 0x00000001, 1, 16, 8000, 1 * 16 * 8000 * 4); 

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 0x00000001, 1, 16, 8000, 1 * 16 * 8000 * 4); 

            string strUserName = "root", strPassword = "root";

            EXPORTS.AMESDK_NETWORK_SET_USER_ACCOUNT(m_hNetworkRendererDev, ref strUserName, ref strPassword);

            // SET TIME OUT = 30 SECONDS
            //
            EXPORTS.AMESDK_NETWORK_SET_STREAMING_PORT(m_hNetworkRendererDev, 554, 30);

            // INITIALIZE FILE RENDERERS
            //
            for (i = 0; i < 4; i++)
            {
                DateTime system_time = DateTime.Now;

                string file_path;

                m_sFileRendererChangeSystemTime[i] = system_time;

                file_path = @"Common Analog File Renderer C:\SC2A0\CH" + (i + 1).ToString("D2") + "\\" +
                                                                    system_time.Year.ToString("D4") +
                                                                    system_time.Month.ToString("D2") +
                                                                    system_time.Day.ToString("D2") +
                                                                    system_time.Hour.ToString("D2") +
                                                                    system_time.Minute.ToString("D2") +
                                                                    system_time.Second.ToString("D2") + ".MP4";

                m_pFileRendererChangeDevName[i] = file_path;

                m_hFileRendererDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hFileRendererDev[0] = EXPORTS.AMESDK_CREATE(ref file_path, 0, 3, 0, null, 0); }

                if (i == 1) { m_hFileRendererDev[1] = EXPORTS.AMESDK_CREATE(ref file_path, 1, 3, 0, null, 0); }

                if (i == 2) { m_hFileRendererDev[2] = EXPORTS.AMESDK_CREATE(ref file_path, 2, 3, 0, null, 0); }

                if (i == 3) { m_hFileRendererDev[3] = EXPORTS.AMESDK_CREATE(ref file_path, 3, 3, 0, null, 0); }

                if ((m_hFileRendererDev[i] & 0x80000000) == 0x80000000) { m_hFileRendererDev[i] = 0xFFFFFFFF; }

                uint custom_flags = 0x00000000;

                EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev[i], 0x34363248, (uint)cx[i], (uint)cy[i], 24, fps[i], custom_flags); //H264 = 0x34363248

                EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev[i], 0x00000001, 1, 16, 8000); // AAC / MONO / 16BITS / 8000HZ
            }

            // INITIALIZE VIDEO STREAMS (YV12)
            //
            string strVideoChipName = "FH8735 PCI";

            for (i = 0; i < 4; i++)
            {
                m_hVideoDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hVideoDev[0] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 0, 0, (uint)m_cChannelControl_LIVE[0].Handle, m_pVideoBufferCB, 0, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 1) { m_hVideoDev[1] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 1, 0, (uint)m_cChannelControl_LIVE[1].Handle, m_pVideoBufferCB, 1, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 2) { m_hVideoDev[2] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 2, 0, (uint)m_cChannelControl_LIVE[2].Handle, m_pVideoBufferCB, 2, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 3) { m_hVideoDev[3] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 3, 0, (uint)m_cChannelControl_LIVE[3].Handle, m_pVideoBufferCB, 3, 0, null, 0, 0, null, 0, 0, null, 0); }

                if ((m_hVideoDev[i] & 0x80000000) == 0x80000000) { m_hVideoDev[i] = 0xFFFFFFFF; }
            }

            for (i = 0; i < 4; i++)
            {
                if ((std & 0x00000001) == 0x00000001)
                {
                    EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev[i], 0x00000001); // NTSC = 0x00000001

                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev[i], 0x32315659, 352, 240, 12, 29.97); // YV12 = &H32315659 // RESOLUTION = 352 × 240 × 29.97 / NTSC (PCI 33MHZ)

                    EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev[i], 0);
                }
                else
                {
                    EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev[i], 0x00000010); // PAL = 0x00000010

                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev[i], 0x32315659, 352, 240, 12, 25.0); // YV12 = &H32315659 // RESOLUTION = 352 × 288 × 25.00 / PALB (PCI 33MHZ)

                    EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev[i], 0);
                }
            }
            
            // INITIALIZE VIDEO MAIN ENCODER STREAMS (H.264)
           //
            string strVideoEncoderDev = "FH8735 PCI, Analog Encoder";

           for (i = 0; i < 4; i++)
           {
               m_hVideoMainEncoderDev[i] = 0xFFFFFFFF;

               if (i == 0) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 0, 0, (uint)m_cChannelControl_H264_MAIN[0].Handle, m_pVideoMainEncoderBufferCB, 0); }

               if (i == 1) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 1, 0, (uint)m_cChannelControl_H264_MAIN[1].Handle, m_pVideoMainEncoderBufferCB, 1); }

               if (i == 2) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 2, 0, (uint)m_cChannelControl_H264_MAIN[2].Handle, m_pVideoMainEncoderBufferCB, 2); }

               if (i == 3) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 3, 0, (uint)m_cChannelControl_H264_MAIN[3].Handle, m_pVideoMainEncoderBufferCB, 3); }

               if ((m_hVideoMainEncoderDev[i] & 0x80000000) == 0x80000000) { m_hVideoMainEncoderDev[i] = 0xFFFFFFFF; }

               EXPORTS.AMESDK_SET_STANDARD(m_hVideoMainEncoderDev[i], (uint)std);  // NTSC = &H00000001 / PAL = &H00000010

               EXPORTS.AMESDK_SET_FORMAT(m_hVideoMainEncoderDev[i], 0x34363248, (uint)cx[i], (uint)cy[i], 24, fps[i]);  // H264 = &H34363248

               EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoMainEncoderDev[i], (uint)deinterlace[i]);  // DISABLE = &H00000000 / BEST = &H00000007

               EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 3, (uint)rcmode[i]);  // RECORD MODE

               if (rcmode[i] == 0) // VBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 1, (uint)quality[i]);  // QUALITY

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 0, (uint)gop[i]); // GOP
               }

               if (rcmode[i] == 1) // CBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 4, (uint)bitrate[i]);  // BITRATE

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 0, (uint)gop[i]); // GOP

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 5, (uint)qpstep[i]); // QPSTEP
               }

               if (rcmode[i] == 2) // HBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 4, (uint)bitrate[i]); // BITRATE

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 1, (uint)quality[i]); // QUALITY

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 0, (uint)gop[i]); // GOP

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 5, (uint)qpstep[i]); // QPSTEP

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 6, (uint)peakbitrate[i]); // PEAK BITRATE

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 7, (uint)troughquality[i]); // TROUGH QUALITY
               }
           }

           // INITIALIZE VIDEO SUB ENCODER STREAMS (H.264)
           //
           for (i = 0; i < 4; i++)
           {
               m_hVideoSubEncoderDev[i] = 0xFFFFFFFF;

               if (i == 0) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 0, 0, (uint)m_cChannelControl_H264_SUB[0].Handle, m_pVideoSubEncoderBufferCB, 0); }

               if (i == 1) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 1, 0, (uint)m_cChannelControl_H264_SUB[1].Handle, m_pVideoSubEncoderBufferCB, 1); }

               if (i == 2) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 2, 0, (uint)m_cChannelControl_H264_SUB[2].Handle, m_pVideoSubEncoderBufferCB, 2); }

               if (i == 3) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 3, 0, (uint)m_cChannelControl_H264_SUB[3].Handle, m_pVideoSubEncoderBufferCB, 3); }

               if ((m_hVideoSubEncoderDev[i] & 0x80000000) == 0x80000000) { m_hVideoSubEncoderDev[i] = 0xFFFFFFFF; }

               EXPORTS.AMESDK_SET_STANDARD(m_hVideoSubEncoderDev[i], (uint)std);  // NTSC = &H00000001 / PAL = &H00000010

               EXPORTS.AMESDK_SET_FORMAT(m_hVideoSubEncoderDev[i], 0x34363258, (uint)cx[i + 4], (uint)cy[i + 4], 24, fps[i + 4]); // X264 = &H34363258

               EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoSubEncoderDev[i], (uint)deinterlace[i + 4]); // DISABLE = &H00000000 / BEST = &H00000007

               EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 3, (uint)rcmode[i + 4]); // RECORD MODE

               if (rcmode[i + 4] == 0) // VBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 1, (uint)quality[i + 4]); // QUALITY (VBR)
               }

               if (rcmode[i + 4] == 1) // CBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 4, (uint)bitrate[i + 4]);  // BITRATE (CBR)
               }

               if (rcmode[i + 4] == 2) // HBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 1, (uint)quality[i + 4]); // QUALITY (HBR)

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 4, (uint)bitrate[i + 4]); // BITRATE (HBR)
               }

               EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 0, (uint)gop[i + 4]); // GOP
           }

           // INITIALIZE AUDIO STREAMS (PCM)
           //
           string strAudioDev = "FH8735 PCI, Analog WaveIn";

           for (i = 0; i < 4; i++)
           {
               m_hAudioDev[i] = 0xFFFFFFFF;

               //if (i == 0) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 0, 0, (uint)m_cChannelControl_LIVE[0].Handle, m_pAudioBufferCB, 0); }

               //if (i == 1) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 1, 0, (uint)m_cChannelControl_LIVE[1].Handle, m_pAudioBufferCB, 1); }

               //if (i == 2) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 2, 0, (uint)m_cChannelControl_LIVE[2].Handle, m_pAudioBufferCB, 2); }

               //if (i == 3) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 3, 0, (uint)m_cChannelControl_LIVE[3].Handle, m_pAudioBufferCB, 3); }

               if (i == 0) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 0, 0, 0, m_pAudioBufferCB, 0); }

               if (i == 1) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 1, 0,0, m_pAudioBufferCB, 1); }

               if (i == 2) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 2, 0, 0, m_pAudioBufferCB, 2); }

               if (i == 3) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 3, 0, 0, m_pAudioBufferCB, 3); }

               if ((m_hAudioDev[i] & 0x80000000) == 0x80000000) { m_hAudioDev[i] = 0xFFFFFFFF; }

               uint n_audio_channels = 0;

               uint n_audio_bits_per_sample = 0;

               uint n_audio_samples_per_sec = 0;

               EXPORTS.AMESDK_SET_FORMAT(m_hAudioDev[i], 1, 16, 8000); // MONO / 16BITS / 8000HZ               

               EXPORTS.AMESDK_GET_FORMAT(m_hAudioDev[i], ref n_audio_channels, ref n_audio_bits_per_sample, ref n_audio_samples_per_sec);
           }

           // INITIALIZE AUDIO ENCODER (AAC)
           //
           string strAudioEncoderDev = "Common Analog Encoder (AAC)";

           for (i = 0; i < 4; i++)
           {
               m_hAudioAACEncoderDev[i] = 0xFFFFFFFF;

               if (i == 0) { m_hAudioAACEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioEncoderDev, 0, 7, 0, null, 0); } // CH#01

               if (i == 1) { m_hAudioAACEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioEncoderDev, 1, 7, 0, null, 0); } // CH#02

               if (i == 2) { m_hAudioAACEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioEncoderDev, 2, 7, 0, null, 0); } // CH#03

               if (i == 3) { m_hAudioAACEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioEncoderDev, 3, 7, 0, null, 0); } // CH#04

               if ((m_hAudioAACEncoderDev[i] & 0x80000000) == 0x80000000) { m_hAudioAACEncoderDev[i] = 0xFFFFFFFF; }

               // SETUP AUDIO AAC ENCODER PATH (AAC) PROPERTIES
               //
               EXPORTS.AMESDK_SET_FORMAT(m_hAudioAACEncoderDev[i], 1, 16, 8000); // MONO / 16BITS / 8000HZ
           }

           // GET DEVICE SERIAL NUMBER
           //  
           EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev[0], 0, ref m_nDeviceSerialNumber);

           // TURN OFF THE TIMESTAMP ( OSD TEXT THAT CONTAINS THE DATE AND TIME )
           //
           // TO CHNGE LINE#1's STRING
           //
           byte[] pbyOsd1 = Encoding.ASCII.GetBytes(" ");

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[0], 920, 0x00000000);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[0], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd1[0])), (uint)pbyOsd1.Length);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[1], 920, 0x00000000);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[1], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd1[0])), (uint)pbyOsd1.Length);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[2], 920, 0x00000000);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[2], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd1[0])), (uint)pbyOsd1.Length);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[3], 920, 0x00000000);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[3], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd1[0])), (uint)pbyOsd1.Length);

           // TO CHNGE LINE#2's STRING
           //
           byte[] pbyOsd2 = Encoding.ASCII.GetBytes(" ");

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[0], 920, 0x00000001);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[0], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd2[0])), (uint)pbyOsd2.Length);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[1], 920, 0x00000001);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[1], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd2[0])), (uint)pbyOsd2.Length);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[2], 920, 0x00000001);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[2], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd2[0])), (uint)pbyOsd2.Length);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY(m_hVideoDev[3], 920, 0x00000001);

           EXPORTS.AMESDK_SET_CUSTOM_PROPERTY_EX(m_hVideoDev[3], 921, (uint)(EXPORTS.HELPER_OBJPTR(ref pbyOsd2[0])), (uint)pbyOsd2.Length);

           // START
           //
           for (i = 0; i < 4; i++)
           {
               g_n_video_frame_number[i] = 0;

               g_n_video_main_encoder_frame_number[i] = 0;

               g_n_video_sub_encoder_frame_number[i] = 0;

               g_d_video_start_sample_time[i] = 0;

               g_d_video_main_encoder_start_sample_time[i] = 0;

               g_d_video_sub_encoder_start_sample_time[i] = 0;

               g_d_video_stop_sample_time[i] = 0;

               g_d_video_main_encoder_stop_sample_time[i] = 0;

               g_d_video_sub_encoder_stop_sample_time[i] = 0;

               g_n_video_main_encoder_stream_size[i] = 0;

               g_n_video_sub_encoder_stream_size[i] = 0;

               g_b_is_start_statistics = false;

               g_n_video_streaming_frame_number[i] = 0;

               g_n_audio_streaming_frame_number[i] = 0;

               g_n_video_streaming_start_sample_time[i] = 0;

               g_n_audio_streaming_start_sample_time[i] = 0;
           }

			for (i = 0; i < 4; i++)
           {
               for (int j = 0; j < 30; j++)
               {
                   n_queue_stream_buffer_size[i][j] = 0;

                   n_queue_stream_buffer_index[i] = 0;
               }
           }
           //  RUN DEVICE
           //
           EXPORTS.AMESDK_RUN(m_hVideoDev[0]);

           EXPORTS.AMESDK_RUN(m_hVideoDev[1]);

           EXPORTS.AMESDK_RUN(m_hVideoDev[2]);

           EXPORTS.AMESDK_RUN(m_hVideoDev[3]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[0]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[1]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[2]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[3]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[0]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[1]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[2]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[3]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[0]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[1]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[2]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[3]);

           EXPORTS.AMESDK_RUN(m_hAudioAACEncoderDev[0]);

           EXPORTS.AMESDK_RUN(m_hAudioAACEncoderDev[1]);

           EXPORTS.AMESDK_RUN(m_hAudioAACEncoderDev[2]);

           EXPORTS.AMESDK_RUN(m_hAudioAACEncoderDev[3]);            

           EXPORTS.AMESDK_RUN(m_hNetworkRendererDev);

           System.Threading.Thread.Sleep(512);

           g_b_is_start_statistics = true;

           // STRAT RECORDING
           //
           m_bFileRendererChangeNotify[0] = false;

           m_bFileRendererChangeNotify[1] = false;

           m_bFileRendererChangeNotify[2] = false;

           m_bFileRendererChangeNotify[3] = false;

           m_nFileRendererRecordState[0] = 1; // ACQUIRE RECORDING

           m_nFileRendererRecordState[1] = 1; // ACQUIRE RECORDING

           m_nFileRendererRecordState[2] = 1; // ACQUIRE RECORDING

           m_nFileRendererRecordState[3] = 1; // ACQUIRE RECORDING

           if (m_hVideoSubEncoderDev[0] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[0] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

           if (m_hVideoSubEncoderDev[1] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[1] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

           if (m_hVideoSubEncoderDev[2] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[2] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

           if (m_hVideoSubEncoderDev[3] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[3] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

            return true;
        }

        public bool HwUninitialize()
        {
            m_nNetworkRendererStreamingState[0] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[1] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[2] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[3] = 0; // STOP STREAMING

            m_nFileRendererRecordState[0] = 0; // STOP RECORDING

            m_nFileRendererRecordState[1] = 0; // STOP RECORDING

            m_nFileRendererRecordState[2] = 0; // STOP RECORDING

            m_nFileRendererRecordState[3] = 0; // STOP RECORDING

            EXPORTS.AMESDK_STOP(m_hVideoDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[3]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[3]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[3]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[0]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[1]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[2]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[3]);

            EXPORTS.AMESDK_STOP(m_hAudioAACEncoderDev[0]);

            EXPORTS.AMESDK_STOP(m_hAudioAACEncoderDev[1]);

            EXPORTS.AMESDK_STOP(m_hAudioAACEncoderDev[2]);

            EXPORTS.AMESDK_STOP(m_hAudioAACEncoderDev[3]);

            uint i = 0;

            for (i = 0; i < 4; i++)
            {
                EXPORTS.AMESDK_DESTROY(m_hVideoDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hVideoMainEncoderDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hVideoSubEncoderDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hAudioDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hAudioAACEncoderDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hFileRendererDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hFileSourceDev[i]);

                m_hVideoDev[i] = 0xFFFFFFFF;

                m_hVideoMainEncoderDev[i] = 0xFFFFFFFF;

                m_hVideoSubEncoderDev[i] = 0xFFFFFFFF;

                m_hAudioDev[i] = 0xFFFFFFFF;

                m_hAudioAACEncoderDev[i] = 0xFFFFFFFF;

                m_hFileRendererDev[i] = 0xFFFFFFFF;
            }

            EXPORTS.AMESDK_DESTROY(m_hNetworkRendererDev);

            m_hNetworkRendererDev = 0xFFFFFFFF;

            return true;
        }

        public void OnLButtonDown_ChannelControl(uint nChannelNumber)
        {
            if ((nChannelNumber & 0x1000000) == 0x1000000) // LIVE PATH
            {
                uint i = nChannelNumber - 0x1000000;

                if (m_cChannelControl_LIVE[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_LIVE[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_LIVE[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_LIVE[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_LIVE[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_LIVE[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_LIVE[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_LIVE[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_LIVE[i].Top = 240; }

                    m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_LIVE[0].Visible = true;
                    m_cChannelControl_LIVE[1].Visible = true;
                    m_cChannelControl_LIVE[2].Visible = true;
                    m_cChannelControl_LIVE[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev[i]);
                }
                else
                {
                    m_cChannelControl_LIVE[i].Left = 0;
                    m_cChannelControl_LIVE[i].Top = 0;
                    m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_LIVE[0].Visible = false;
                    m_cChannelControl_LIVE[1].Visible = false;
                    m_cChannelControl_LIVE[2].Visible = false;
                    m_cChannelControl_LIVE[3].Visible = false;
                    m_cChannelControl_LIVE[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev[i]);
                }
            }

            if ((nChannelNumber & 0x2000000) == 0x2000000) // FILE STREAM PATH
            {
                uint i = nChannelNumber - 0x2000000;

                if (m_cChannelControl_FILE[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_FILE[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_FILE[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_FILE[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_FILE[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_FILE[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_FILE[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_FILE[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_FILE[i].Top = 240; }

                    m_cChannelControl_FILE[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_FILE[0].Visible = true;
                    m_cChannelControl_FILE[1].Visible = true;
                    m_cChannelControl_FILE[2].Visible = true;
                    m_cChannelControl_FILE[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev[i]);
                }
                else
                {
                    m_cChannelControl_FILE[i].Left = 0;
                    m_cChannelControl_FILE[i].Top = 0;
                    m_cChannelControl_FILE[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_FILE[0].Visible = false;
                    m_cChannelControl_FILE[1].Visible = false;
                    m_cChannelControl_FILE[2].Visible = false;
                    m_cChannelControl_FILE[3].Visible = false;
                    m_cChannelControl_FILE[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev[i]);
                }
            }

            if ((nChannelNumber & 0x4000000) == 0x4000000) // H.264 MAIN.STREAM PATH
            {
                uint i = nChannelNumber - 0x4000000;

                if (m_cChannelControl_H264_MAIN[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_H264_MAIN[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_H264_MAIN[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_H264_MAIN[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_H264_MAIN[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_H264_MAIN[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_H264_MAIN[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_H264_MAIN[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_H264_MAIN[i].Top = 240; }

                    m_cChannelControl_H264_MAIN[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_H264_MAIN[0].Visible = true;
                    m_cChannelControl_H264_MAIN[1].Visible = true;
                    m_cChannelControl_H264_MAIN[2].Visible = true;
                    m_cChannelControl_H264_MAIN[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoMainEncoderDev[i]);
                }
                else
                {
                    m_cChannelControl_H264_MAIN[i].Left = 0;
                    m_cChannelControl_H264_MAIN[i].Top = 0;
                    m_cChannelControl_H264_MAIN[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_H264_MAIN[0].Visible = false;
                    m_cChannelControl_H264_MAIN[1].Visible = false;
                    m_cChannelControl_H264_MAIN[2].Visible = false;
                    m_cChannelControl_H264_MAIN[3].Visible = false;
                    m_cChannelControl_H264_MAIN[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoMainEncoderDev[i]);
                }
            }

            if ((nChannelNumber & 0x8000000) == 0x8000000) // H.264 SUB.STREAM PATH
            {
                uint i = nChannelNumber - 0x8000000;

                if (m_cChannelControl_H264_SUB[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_H264_SUB[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_H264_SUB[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_H264_SUB[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_H264_SUB[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_H264_SUB[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_H264_SUB[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_H264_SUB[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_H264_SUB[i].Top = 240; }

                    m_cChannelControl_H264_SUB[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_H264_SUB[0].Visible = true;
                    m_cChannelControl_H264_SUB[1].Visible = true;
                    m_cChannelControl_H264_SUB[2].Visible = true;
                    m_cChannelControl_H264_SUB[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoSubEncoderDev[i]);
                }
                else
                {
                    m_cChannelControl_H264_SUB[i].Left = 0;
                    m_cChannelControl_H264_SUB[i].Top = 0;
                    m_cChannelControl_H264_SUB[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_H264_SUB[0].Visible = false;
                    m_cChannelControl_H264_SUB[1].Visible = false;
                    m_cChannelControl_H264_SUB[2].Visible = false;
                    m_cChannelControl_H264_SUB[3].Visible = false;
                    m_cChannelControl_H264_SUB[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoSubEncoderDev[i]);
                }
            }
        }

        public void OnCheckedChanged_RadioButton_SetupControl(uint nRadioButtonNumber)
        {
            if (nRadioButtonNumber == 0) // LIVE PATH
            {
                m_nDisplayTabNumber = 0;

                m_cChannelControl_LIVE[0].Visible = true;
                m_cChannelControl_LIVE[1].Visible = true;
                m_cChannelControl_LIVE[2].Visible = true;
                m_cChannelControl_LIVE[3].Visible = true;
                m_cChannelControl_FILE[0].Visible = false;
                m_cChannelControl_FILE[1].Visible = false;
                m_cChannelControl_FILE[2].Visible = false;
                m_cChannelControl_FILE[3].Visible = false;
                m_cChannelControl_H264_MAIN[0].Visible = false;
                m_cChannelControl_H264_MAIN[1].Visible = false;
                m_cChannelControl_H264_MAIN[2].Visible = false;
                m_cChannelControl_H264_MAIN[3].Visible = false;
                m_cChannelControl_H264_SUB[0].Visible = false;
                m_cChannelControl_H264_SUB[1].Visible = false;
                m_cChannelControl_H264_SUB[2].Visible = false;
                m_cChannelControl_H264_SUB[3].Visible = false;
            }

            if (nRadioButtonNumber == 1) // FILE STREAM PATH
            {
                m_nDisplayTabNumber = 1;

                m_cChannelControl_FILE[0].Visible = true;
                m_cChannelControl_FILE[1].Visible = true;
                m_cChannelControl_FILE[2].Visible = true;
                m_cChannelControl_FILE[3].Visible = true;
                m_cChannelControl_LIVE[0].Visible = false;
                m_cChannelControl_LIVE[1].Visible = false;
                m_cChannelControl_LIVE[2].Visible = false;
                m_cChannelControl_LIVE[3].Visible = false;
                m_cChannelControl_H264_MAIN[0].Visible = false;
                m_cChannelControl_H264_MAIN[1].Visible = false;
                m_cChannelControl_H264_MAIN[2].Visible = false;
                m_cChannelControl_H264_MAIN[3].Visible = false;
                m_cChannelControl_H264_SUB[0].Visible = false;
                m_cChannelControl_H264_SUB[1].Visible = false;
                m_cChannelControl_H264_SUB[2].Visible = false;
                m_cChannelControl_H264_SUB[3].Visible = false;
            }

            if (nRadioButtonNumber == 2) // H.264 MAIN.STREAM PATH
            {
                m_nDisplayTabNumber = 2;

                m_cChannelControl_H264_MAIN[0].Visible = true;
                m_cChannelControl_H264_MAIN[1].Visible = true;
                m_cChannelControl_H264_MAIN[2].Visible = true;
                m_cChannelControl_H264_MAIN[3].Visible = true;
                m_cChannelControl_LIVE[0].Visible = false;
                m_cChannelControl_LIVE[1].Visible = false;
                m_cChannelControl_LIVE[2].Visible = false;
                m_cChannelControl_LIVE[3].Visible = false;
                m_cChannelControl_FILE[0].Visible = false;
                m_cChannelControl_FILE[1].Visible = false;
                m_cChannelControl_FILE[2].Visible = false;
                m_cChannelControl_FILE[3].Visible = false;
                m_cChannelControl_H264_SUB[0].Visible = false;
                m_cChannelControl_H264_SUB[1].Visible = false;
                m_cChannelControl_H264_SUB[2].Visible = false;
                m_cChannelControl_H264_SUB[3].Visible = false;
            }

            if (nRadioButtonNumber == 3) // H.264 SUB.STREAM PATH
            {
                m_nDisplayTabNumber = 3;

                m_cChannelControl_H264_SUB[0].Visible = true;
                m_cChannelControl_H264_SUB[1].Visible = true;
                m_cChannelControl_H264_SUB[2].Visible = true;
                m_cChannelControl_H264_SUB[3].Visible = true;
                m_cChannelControl_LIVE[0].Visible = false;
                m_cChannelControl_LIVE[1].Visible = false;
                m_cChannelControl_LIVE[2].Visible = false;
                m_cChannelControl_LIVE[3].Visible = false;
                m_cChannelControl_FILE[0].Visible = false;
                m_cChannelControl_FILE[1].Visible = false;
                m_cChannelControl_FILE[2].Visible = false;
                m_cChannelControl_FILE[3].Visible = false;
                m_cChannelControl_H264_MAIN[0].Visible = false;
                m_cChannelControl_H264_MAIN[1].Visible = false;
                m_cChannelControl_H264_MAIN[2].Visible = false;
                m_cChannelControl_H264_MAIN[3].Visible = false;
            }
        }

        public bool OnFileSourceCreate_FileManagerWindow(uint nChannelNumber, ref EXPORTS.AMESDK_FILE_INFO pFileInfo)
        {
            if (m_hFileSourceDev[nChannelNumber] == 0xFFFFFFFF)
            {
                string pszFileSourceName = @"Common Analog File Source " + ByteArrayToString(pFileInfo.m_pszFileName);// +Encoding.ASCII.GetString(pFileInfo.m_pszFileName.ToString());

                m_hFileSourceDev[nChannelNumber] = EXPORTS.AMESDK_CREATE(ref pszFileSourceName, nChannelNumber, 2, (uint)m_cChannelControl_FILE[nChannelNumber].Handle.ToInt32(), null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

                if ((m_hFileSourceDev[nChannelNumber] & 0x80000000) == 0x80000000)
                {
                    m_hFileSourceDev[nChannelNumber] = 0xFFFFFFFF;
                }
            }

            return true;
        }

        public uint OnFileSourceRun_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_RUN(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourcePause_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_PAUSE(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourceStop_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_STOP(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourceStep_FileManagerWindow(uint nChannelNumber, uint nSteps)
        {
            return EXPORTS.AMESDK_STEP(m_hFileSourceDev[nChannelNumber], nSteps);
        }

        public uint OnFileSourceGetVideoStreamData_FileManagerWindow(uint nChannelNumber, uint nSample, ref UInt64 pTimeStamp, ref uint pIsKeyFrame)
        {
            return EXPORTS.AMESDK_FILE_GET_VIDEO_STREAM_DATA(m_hFileSourceDev[nChannelNumber], nSample, ref pTimeStamp, ref pIsKeyFrame);
        }

        public uint OnFileSourceGetAudioStreamData_FileManagerWindow(uint nChannelNumber, uint nSample, ref UInt64 pTimeStamp)
        {
            return EXPORTS.AMESDK_FILE_GET_AUDIO_STREAM_DATA(m_hFileSourceDev[nChannelNumber], nSample, ref pTimeStamp);
        }

        public long OnFileSourceGetMediaLength_FileManagerWindow(uint nChannelNumber, uint dwTimeUnits)
        {
            long nLength = 0;

            EXPORTS.AMESDK_FILE_GET_MEDIA_LENGTH(m_hFileSourceDev[nChannelNumber], ref nLength, dwTimeUnits);

            return nLength;
        }

        public uint OnFileSourceSetMediaPosition_FileManagerWindow(uint nChannelNumber, long nPosition, uint dwTimeUnits)
        {
            return EXPORTS.AMESDK_FILE_SET_MEDIA_POSITION(m_hFileSourceDev[nChannelNumber], nPosition, dwTimeUnits);
        }

        public double OnFileSourceGetMediaPlaybackRate_FileManagerWindow(uint nChannelNumber)
        {
            double dRate = 0.0;

            EXPORTS.AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE(m_hFileSourceDev[nChannelNumber], ref dRate);

            return dRate;
        }

        public uint OnFileSourceSetMediaPlaybackRate_FileManagerWindow(uint nChannelNumber, double dRate)
        {
            return EXPORTS.AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE(m_hFileSourceDev[nChannelNumber], dRate);
        }

        public void OnFileSourceDestroy_FileManagerWindow(uint nChannelNumber)
        {
            if (m_hFileSourceDev[nChannelNumber] != 0xFFFFFFFF)
            {
                EXPORTS.AMESDK_DESTROY(m_hFileSourceDev[nChannelNumber]);

                m_hFileSourceDev[nChannelNumber] = 0xFFFFFFFF;
            }
        }
        
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == 0x00000014) // 0x00000014 = WM_ERASEBKGND
            {
                return;
            }

            if (m.Msg == 0x400) // 0x400 = WM_USER (UPDATE FILE INFO LIST)
            {
                DateTime system_time = DateTime.Now;

                DateTime start_search_system_time = new DateTime(system_time.Year, system_time.Month, system_time.Day);

                DateTime stop_search_system_time = new DateTime(system_time.Year, system_time.Month, system_time.Day, 23, 59, 59, 999);

                UInt64 n_start_search_systemtime = (UInt64)start_search_system_time.ToFileTimeUtc();

                UInt64 n_stop_search_systemtime = (UInt64)stop_search_system_time.ToFileTimeUtc();

                UInt32 i = (UInt32)m.WParam;

                string psz_search_directory = @"C:\\SC2A0\\CH" + (i + 1).ToString("D2") + "\\";

                uint nSearchProgress = 0, nRepairProgress = 0;

                EXPORTS.AMESDK_FILE_UPDATE_FILE_INFO_LIST(m_cSetupControl.m_cFileManagerControl.m_pFileInfoList[i], ref psz_search_directory, n_start_search_systemtime, n_stop_search_systemtime, 0, ref nSearchProgress, ref nRepairProgress); // 18446744073709551615 = &HFFFFFFFFFFFFFFFF

                m_cSetupControl.m_cFileManagerControl.Invalidate(true);
            }

            base.WndProc(ref m);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            /*
            double[] fps = new double[12];

            double[] bps = new double[12];

            uint i = 0;

            for (i = 0; i < 12; i++) { fps[i] = 0; bps[i] = 0; }

            if (g_n_video_frame_number[0] > 0) { fps[0] = (g_d_video_stop_sample_time[0] - g_d_video_start_sample_time[0]) / (g_n_video_frame_number[0]); }

            if (g_n_video_frame_number[1] > 0) { fps[1] = (g_d_video_stop_sample_time[1] - g_d_video_start_sample_time[1]) / (g_n_video_frame_number[1]); }

            if (g_n_video_frame_number[2] > 0) { fps[2] = (g_d_video_stop_sample_time[2] - g_d_video_start_sample_time[2]) / (g_n_video_frame_number[2]); }

            if (g_n_video_frame_number[3] > 0) { fps[3] = (g_d_video_stop_sample_time[3] - g_d_video_start_sample_time[3]) / (g_n_video_frame_number[3]); }

            if (g_n_video_main_encoder_frame_number[0] > 0) { fps[4] = (g_d_video_main_encoder_stop_sample_time[0] - g_d_video_main_encoder_start_sample_time[0]) / (g_n_video_main_encoder_frame_number[0]); }

            if (g_n_video_main_encoder_frame_number[1] > 0) { fps[5] = (g_d_video_main_encoder_stop_sample_time[1] - g_d_video_main_encoder_start_sample_time[1]) / (g_n_video_main_encoder_frame_number[1]); }

            if (g_n_video_main_encoder_frame_number[2] > 0) { fps[6] = (g_d_video_main_encoder_stop_sample_time[2] - g_d_video_main_encoder_start_sample_time[2]) / (g_n_video_main_encoder_frame_number[2]); }

            if (g_n_video_main_encoder_frame_number[3] > 0) { fps[7] = (g_d_video_main_encoder_stop_sample_time[3] - g_d_video_main_encoder_start_sample_time[3]) / (g_n_video_main_encoder_frame_number[3]); }

            if (g_n_video_sub_encoder_frame_number[0] > 0) { fps[8] = (g_d_video_sub_encoder_stop_sample_time[0] - g_d_video_sub_encoder_start_sample_time[0]) / (g_n_video_sub_encoder_frame_number[0]); }

            if (g_n_video_sub_encoder_frame_number[1] > 0) { fps[9] = (g_d_video_sub_encoder_stop_sample_time[1] - g_d_video_sub_encoder_start_sample_time[1]) / (g_n_video_sub_encoder_frame_number[1]); }

            if (g_n_video_sub_encoder_frame_number[2] > 0) { fps[10] = (g_d_video_sub_encoder_stop_sample_time[2] - g_d_video_sub_encoder_start_sample_time[2]) / (g_n_video_sub_encoder_frame_number[2]); }

            if (g_n_video_sub_encoder_frame_number[3] > 0) { fps[11] = (g_d_video_sub_encoder_stop_sample_time[3] - g_d_video_sub_encoder_start_sample_time[3]) / (g_n_video_sub_encoder_frame_number[3]); }

            if ((g_d_video_main_encoder_stop_sample_time[0] - g_d_video_main_encoder_start_sample_time[0]) > 0) { bps[4] = (uint)(g_n_video_main_encoder_stream_size[0] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[0] - g_d_video_main_encoder_start_sample_time[0]) / 100.0; }

            if ((g_d_video_main_encoder_stop_sample_time[1] - g_d_video_main_encoder_start_sample_time[1]) > 0) { bps[5] = (uint)(g_n_video_main_encoder_stream_size[1] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[1] - g_d_video_main_encoder_start_sample_time[1]) / 100.0; }

            if ((g_d_video_main_encoder_stop_sample_time[2] - g_d_video_main_encoder_start_sample_time[2]) > 0) { bps[6] = (uint)(g_n_video_main_encoder_stream_size[2] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[2] - g_d_video_main_encoder_start_sample_time[2]) / 100.0; }

            if ((g_d_video_main_encoder_stop_sample_time[3] - g_d_video_main_encoder_start_sample_time[3]) > 0) { bps[7] = (uint)(g_n_video_main_encoder_stream_size[3] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[3] - g_d_video_main_encoder_start_sample_time[3]) / 100.0; }

            if ((g_d_video_sub_encoder_stop_sample_time[0] - g_d_video_sub_encoder_start_sample_time[0]) > 0) { bps[8] = (uint)(g_n_video_sub_encoder_stream_size[0] * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[0] - g_d_video_sub_encoder_start_sample_time[0]) / 100.0; }

            if ((g_d_video_sub_encoder_stop_sample_time[1] - g_d_video_sub_encoder_start_sample_time[1]) > 0) { bps[9] = (uint)(g_n_video_sub_encoder_stream_size[1] * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[1] - g_d_video_sub_encoder_start_sample_time[1]) / 100.0; }

            if ((g_d_video_sub_encoder_stop_sample_time[2] - g_d_video_sub_encoder_start_sample_time[2]) > 0) { bps[10] = (uint)(g_n_video_sub_encoder_stream_size[2] * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[2] - g_d_video_sub_encoder_start_sample_time[2]) / 100.0; }

            if ((g_d_video_sub_encoder_stop_sample_time[3] - g_d_video_sub_encoder_start_sample_time[3]) > 0) { bps[11] = (uint)(g_n_video_sub_encoder_stream_size[3] * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[3] - g_d_video_sub_encoder_start_sample_time[3]) / 100.0; }            

            string str1 = @"FPS = |" + fps[0].ToString("F6") + "|" + fps[1].ToString("F6") + "|" + fps[2].ToString("F6") + "|" + fps[3].ToString("F6") + "|" + fps[4].ToString("F6") + "|" + fps[5].ToString("F6") + "|" + fps[6].ToString("F6") + "|" + fps[7].ToString("F6") + "|" + fps[8].ToString("F6") + "|" + fps[9].ToString("F6") + "|" + fps[10].ToString("F6") + "|" + fps[11].ToString("F6") + "|\n";

            OutputDebugString(str1);

            string str2 = @"BPS = |" + bps[0].ToString("F6") + "|" + bps[1].ToString("F6") + "|" + bps[2].ToString("F6") + "|" + bps[3].ToString("F6") + "|" + bps[4].ToString("F6") + "|" + bps[5].ToString("F6") + "|" + bps[6].ToString("F6") + "|" + bps[7].ToString("F6") + "|" + bps[8].ToString("F6") + "|" + bps[9].ToString("F6") + "|" + bps[10].ToString("F6") + "|" + bps[11].ToString("F6") + "|\n";

            OutputDebugString(str2);

            string str3 = @"NUM = |" + g_n_video_frame_number[0].ToString("D8") + "|" + g_n_video_frame_number[1].ToString("D8") + "|" + g_n_video_frame_number[2].ToString("D8") + "|" + g_n_video_frame_number[3].ToString("D8")  + "|" + g_n_video_main_encoder_frame_number[0].ToString("D8") + "|" + g_n_video_main_encoder_frame_number[1].ToString("D8") + "|" + g_n_video_main_encoder_frame_number[2].ToString("D8") + "|" + g_n_video_main_encoder_frame_number[3].ToString("D8") + "|"  + g_n_video_sub_encoder_frame_number[0].ToString("D8") + "|" + g_n_video_sub_encoder_frame_number[1].ToString("D8") + "|" + g_n_video_sub_encoder_frame_number[2].ToString("D8") + "|" + g_n_video_sub_encoder_frame_number[3].ToString("D8") + "|\n";

            OutputDebugString(str3);
            */
        }

    }
}
